% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ctrMongo}
\alias{ctrMongo}
\title{Set up connections to a Mongo DB server database}
\usage{
ctrMongo(collection = "ctrdata", uri = "mongodb://localhost/users",
  password = Sys.getenv("ctrdatamongopassword"), verbose = FALSE)
}
\arguments{
\item{collection}{Name of collection (default is "ctrdata")}

\item{uri}{Default is mongodb://localhost/users/.
Address of database in mongodb server, based on mongo connection string
format: mongodb://[username@]host1[:port1][,...hostN[:portN]]]/database/
Do NOT include password, this will only be used from the parameter.
See \url{http://docs.mongodb.org/manual/reference/connection-string/}}

\item{password}{In case access requires credentials.
Note this defaults to the environment variable "ctrdatamongopassword".
(by means of \code{Sys.getenv("ctrdatamongopassword")}), to
support scripting without revealing secrets.}

\item{verbose}{Print information.}
}
\value{
A mongo data base object, currently using mongolite
}
\description{
Set up connections to a Mongo DB server database
}
\keyword{internal}
