% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrdata.R
\docType{package}
\name{ctrdata-package}
\alias{ctrdata-package}
\title{ctrdata: Retrieve and Analyze Clinical Trials in Public Registers}
\description{
A system for querying, retrieving and analyzing protocol- and results-related information on clinical trials from four public registers, the 'European Union Clinical Trials Register' ('EUCTR', \url{https://www.clinicaltrialsregister.eu/}), 'ClinicalTrials.gov' (\url{https://clinicaltrials.gov/} and also translating queries the retired classic interface), the 'ISRCTN' (\url{http://www.isrctn.com/}) and the 'European Union Clinical Trials Information System' ('CTIS', \url{https://euclinicaltrials.eu/}). Trial information is downloaded, converted and stored in a database ('PostgreSQL', 'SQLite', 'DuckDB' or 'MongoDB'; via package 'nodbi'). Documents in registers associated with trials can also be downloaded. Other functions implement trial concepts canonically across registers, identify deduplicated records, easily find and extract variables (fields) of interest even from complex nested data as used by the registers, merge variables and update queries. The package can be used for meta-analysis and trend-analysis of the design and conduct as well as of the results of clinical trials across registers.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://cran.r-project.org/package=ctrdata}
  \item \url{https://rfhb.github.io/ctrdata/}
  \item Report bugs at \url{https://github.com/rfhb/ctrdata/issues}
}

}
\author{
\strong{Maintainer}: Ralf Herold \email{ralf.herold@mailbox.org} (\href{https://orcid.org/0000-0002-8148-6748}{ORCID})

}
\keyword{internal}
