% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctWideToLong.R
\name{ctWideToLong}
\alias{ctWideToLong}
\title{ctWideToLong
Convert ctsem wide to long format}
\usage{
ctWideToLong(datawide, Tpoints, n.manifest, n.TDpred = 0, n.TIpred = 0,
  manifestNames = "auto", TDpredNames = "auto", TIpredNames = "auto")
}
\arguments{
\item{datawide}{ctsem wide format data}

\item{Tpoints}{number of measurement occasions in data}

\item{n.manifest}{number of manifest variables}

\item{n.TDpred}{number of time dependent predictors}

\item{n.TIpred}{number of time independent predictors}

\item{manifestNames}{Character vector of manifest variable names.}

\item{TDpredNames}{Character vector of time dependent predictor names.}

\item{TIpredNames}{Character vector of time independent predictor names.}
}
\description{
ctWideToLong
Convert ctsem wide to long format
}
\details{
Names must account for *all* the columns in the data - i.e. do not leave certain variables out
just because you do not need them.
}
\examples{
 #First load the example ctsem wide format data with absolute times
 data('datastructure')
 datastructure #contains two time intervals (dTx), therefore 3 time points.
 #Then convert to long format
 longexample <- ctWideToLong(datawide = datastructure, Tpoints=3, 
 n.manifest=3, manifestNames = c("Y1", "Y2", "Y3"),
 n.TDpred=1, TDpredNames = "TD1", 
 n.TIpred=2, TIpredNames = c("TI1", "TI2"))

 #Then convert the time intervals to absolute time
 long <- ctDeintervalise(datalong = longexample, id='id', dT='dT')
 long


}
