% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctKalman.R
\name{ctKalman}
\alias{ctKalman}
\title{ctKalman}
\usage{
ctKalman(fit, datalong = NULL, timerange = "asdata",
  timestep = "asdata", subjects = 1, plot = FALSE, ...)
}
\arguments{
\item{fit}{fit object as generated by \code{\link{ctStanFit}}.}

\item{datalong}{Optional long format data object as used by \code{\link{ctStanFit}}. 
If not included, data from fit will used.}

\item{timerange}{Either 'asdata' to just use the observed data range, or a numeric vector of length 2 denoting start and end of time range, 
allowing for estimates outside the range of observed data.}

\item{timestep}{Either 'asdata' to just use the observed data 
(which also requires 'asdata' for timerange) or a positive numeric value
indicating the time step to use for interpolating values. Lower values give a more accurate / smooth representation,
but take a little more time to calculate.}

\item{subjects}{vector of integers denoting which subjects (from 1 to N) to plot predictions for.}

\item{plot}{Logical. If TRUE, plots output instead of returning it. 
See \code{\link{ctKalmanPlot}} for the possible arguments.}

\item{...}{additional arguments to pass to \code{\link{ctKalmanPlot}}.}
}
\value{
Returns a list containing matrix objects etaprior, etaupd, etasmooth, y, yprior, 
yupd, ysmooth, prederror, time, loglik,  with values for each time point in each row. 
eta refers to latent states and y to manifest indicators - y itself is thus just 
the input data. 
Covariance matrices etapriorcov, etaupdcov, etasmoothcov, ypriorcov, yupdcov, ysmoothcov,  
are returned in a row * column * time array. 
If plot=TRUE, nothing is returned but a plot is generated.
}
\description{
Outputs predicted, updated, and smoothed estimates of manifest indicators and latent states, 
with covariances, for specific subjects from data fit with \code{\link{ctStanFit}}, 
based on medians of parameter distribution.
}
\examples{
\dontrun{
#Basic
ctKalman(ctstantestfit, timerange=c(0,60), timestep=.5, plot=TRUE)

#Multiple subjects, y and yprior, showing plot arguments
ctKalman(ctstantestfit, timerange=c(0,60), timestep=.1, plot=TRUE,
  subjects=2:3, 
  kalmanvec=c('y','yprior'),
  errorvec=c(NA,'ypriorcov'), #'auto' would also have achieved this
  ltyvec="auto",
  colvec='auto', 
  lwdvec='auto', 
  subsetindices=2, #Only plotting 2nd dimension of y and yprior
  pchvec='auto', typevec='auto',grid=TRUE,legend=TRUE,
  plotcontrol=list(xlim=c(0,55),main='Observations and priors'),
  polygoncontrol=list(steps=5))
  }
}
