% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctKalman.R
\name{plot.ctKalman}
\alias{plot.ctKalman}
\title{Plots Kalman filter output from ctKalman.}
\usage{
\method{plot}{ctKalman}(x, subjects = 1, kalmanvec = c("y", "ysmooth"),
  errorvec = "auto", errormultiply = 1.96, ltyvec = "auto",
  colvec = "auto", lwdvec = "auto", subsetindices = NULL,
  pchvec = "auto", typevec = "auto", grid = FALSE, add = FALSE,
  plotcontrol = list(ylab = "Value", xlab = "Time", xaxs = "i", lwd = 2,
  mgp = c(2, 0.8, 0)), polygoncontrol = list(steps = 20),
  polygonalpha = 0.3, legend = TRUE, legendcontrol = list(x =
  "topright", bg = "white", cex = 0.7), ...)
}
\arguments{
\item{x}{Output from \code{\link{ctKalman}}. In general it is easier to call 
\code{\link{ctKalman}} directly with the \code{plot=TRUE} argument, which calls this function.}

\item{subjects}{vector of integers denoting which subjects (from 1 to N) to plot predictions for.}

\item{kalmanvec}{string vector of names of any elements of the output you wish to plot, 
the defaults of 'y' and 'yprior' plot the original data, 'y', 
and the prior from the Kalman filter for y. Replacing 'y' by 'eta' will 
plot latent variables instead (though 'eta' alone does not exist) and replacing 'prior' 
with 'upd' or 'smooth' respectively plotting updated (conditional on all data up to current time point)
or smoothed (conditional on all data) estimates.}

\item{errorvec}{vector of names of covariance elements to use for uncertainty indication 
around the kalmanvec items. 'auto' uses the latent covariance when plotting
latent states, and total covariance when plotting expectations of observed states. 
Use NA to skip uncertainty plotting.}

\item{errormultiply}{Numeric denoting the multiplication factor of the std deviation of errorvec objects. 
Defaults to 1.96, for 95\% intervals.}

\item{ltyvec}{vector of line types, varying over dimensions of the kalmanvec object.}

\item{colvec}{color vector, varying either over subject if multiple subjects, or otherwise over 
the dimensions of the kalmanvec object.}

\item{lwdvec}{vector of line widths, varying over the kalmanvec objects.}

\item{subsetindices}{Either NULL, or vector of integers to use for subsetting the (columns) of kalmanvec objects.}

\item{pchvec}{vector of symbol types, varying over the dimensions of the kalmanvec object.}

\item{typevec}{vector of plot types, varying over the kalmanvec objects. 'auto' plots lines for
any  'prior', 'upd', or 'smooth' objects, and points otherwise.}

\item{grid}{Logical. Plot a grid?}

\item{add}{Logical. Create a new plot or update existing plot?}

\item{plotcontrol}{List of graphical arguments (see \code{\link{par}}), 
though lty,col,lwd,x,y, will all be ignored.}

\item{polygoncontrol}{List of arguments to the \code{\link{ctPoly}} function for filling the uncertainty region.}

\item{polygonalpha}{Numeric for the opacity of the uncertainty region.}

\item{legend}{Logical, whether to include a legend if plotting.}

\item{legendcontrol}{List of arguments to the \code{\link{legend}} function.}

\item{...}{not used.}
}
\value{
Generates plots.
}
\description{
Plots Kalman filter output from ctKalman.
}
\examples{
\donttest{
data(AnomAuth) 
AnomAuthmodel <- ctModel(LAMBDA = matrix(c(1, 0, 0, 1), nrow = 2, ncol = 2), 
  Tpoints = 5, n.latent = 2, n.manifest = 2,  TRAITVAR = NULL) 
AnomAuthfit <- ctFit(AnomAuth, AnomAuthmodel)
ctKalman(AnomAuthfit,subjects=1,plot=TRUE)
}
}
