% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{profile.ctsmTMB.fit}
\alias{profile.ctsmTMB.fit}
\title{#' Performs full multi-dimensional profile likelihood calculations}
\usage{
\method{profile}{ctsmTMB.fit}(
  fitted,
  parlist,
  grid.size = rep(10, length(parlist)),
  grid.qnt = rep(3, length(parlist)),
  hessian = FALSE,
  silent = FALSE,
  control = list(trace = 0, iter.max = 1000, eval.max = 1000),
  ...
)
}
\arguments{
\item{fitted}{a ctmsTMB fit object}

\item{parlist}{a named-list of parameters to profile over. The user can either
supply grid-values in the list or leave it empty. If the any one list is empty
then grid-values will be calculated using the estimated parameter mean value
and standard deviation.}

\item{grid.size}{a vector of \code{length(parlist)} indicating the number
of grid-points along each parameter direction. This is only used if the
\code{parlist} is empty.}

\item{grid.qnt}{a vector of \code{length(parlist)} determining the width of
the grid points from the mean value in multiples of the standard deviation.}

\item{hessian}{a boolean indicating whether to use the hessian or not during
the profile optimization.}

\item{silent}{boolean whether or not to mute current iteration number
the \code{control} argument.}

\item{control}{a list of optimization output controls (see \link[stats]{nlminb})}

\item{...}{various arguments (not in use)}
}
\description{
#' Performs full multi-dimensional profile likelihood calculations
}
\note{
The implementation was modified from that of
https://github.com/kaskr/adcomp/blob/master/TMB/R/tmbprofile.R
}
\examples{
library(ctsmTMB)
model <- ctsmTMB$new()

# create model
model$addSystem(dx ~ theta * (mu+u-x) * dt + sigma_x*dw)
model$addObs(y ~ x)
model$setVariance(y ~ sigma_y^2)
model$addInput(u)
model$setParameter(
  theta   = c(initial = 1, lower=1e-5, upper=50),
  mu      = c(initial=1.5, lower=0, upper=5),
  sigma_x = c(initial=1, lower=1e-10, upper=30),
  sigma_y = 1e-2
)
model$setInitialState(list(1,1e-1))

# fit model to data
fit <- model$estimate(Ornstein)

# calculate profile likelihood
out <- profile(fit,parlist=list(theta=NULL))
}
