% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_chemical_by_property_range_batch}
\alias{get_chemical_by_property_range_batch}
\title{Retrieve chemicals by property and value range in batch search}
\usage{
get_chemical_by_property_range_batch(
  start_list = NULL,
  end_list = NULL,
  property_list = NULL,
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{start_list}{Numeric values, the beginning of the range}

\item{end_list}{Numeric values, the end of the range}

\item{property_list}{Strings, the properties being queried}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of data.frames containing chemical information for the
chemicals matching the search criteria.
}
\description{
Retrieve chemicals by property and value range in batch search
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemicals by property ranges
prop_ranges <- get_chemical_by_property_range_batch(start_list = c(1.311,
                                                                   211.99),
                                                    end_list = c(1.313,
                                                                     212.01),
                                                    property_list = c('Density',
                                                                      'Boiling Point'))
\dontshow{\}) # examplesIf}
}
