% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequences.R
\name{count_codons}
\alias{count_codons}
\title{Count occurrences of different codons}
\usage{
count_codons(seqs, ...)
}
\arguments{
\item{seqs}{CDS sequences, DNAStringSet.}

\item{...}{additional arguments passed to `Biostrings::trinucleotideFrequency`.}
}
\value{
matrix of codon (column) frequencies of each CDS (row).
}
\description{
\code{count_codons} tabulates the occurrences of all the 64 codons in input CDSs
}
\examples{
# count codon occurrences
cf_all <- count_codons(yeast_cds)
dim(cf_all)
cf_all[1:5, 1:5]
count_codons(yeast_cds[1])

}
