% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_gc4d}
\alias{get_gc4d}
\title{GC contents at 4-fold degenerate sites}
\usage{
get_gc4d(cf, codon_table = get_codon_table())
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by `count_codons()`.}

\item{codon_table}{a table of genetic code derived from `get_codon_table` or `create_codon_table`.}
}
\value{
a named vector of GC4d values.
}
\description{
Calculate GC content at synonymous position of codons (using four-fold degenerate sites only).
}
\examples{
# estimate GC4d of yeast genes
cf_all <- count_codons(yeast_cds)
gc4d <- get_gc4d(cf_all)
head(gc4d)
hist(gc4d)

}
