\name{cudaMultireg.volume}
\alias{cudaMultireg.volume}
\concept{bayes}
\concept{MCMC}
\concept{Gibbs Sampling}
\concept{hierarchical models}
\concept{linear model}

\title{CUDA Parallel Implementation of a Bayesian Multilevel Model for fMRI Data Analysis on a fMRI NIFTI volume}
\description{
  \code{cudaMultireg.volume} provides an interface to a CUDA implementation
    of a Bayesian multilevel model for the analysis of brain fMRI data.
    Data is processed on a slice-by-slice basis.
    Data volumes in gzipped NIFTI format are used.
}
\usage{
cudaMultireg.volume(fbase=NULL, R=2000, keep=5, nu.e=3,
  zprior=FALSE, rng=0, rg=c(NULL,NULL), swap=FALSE, savedir=tempdir())
}
\arguments{
\item{fbase}{If \code{fbase} is left unspecified (default \code{NULL}),
  then user datasets need to be provided as input. Otherwise, \code{fbase}
  indicates the dataset prefix of one of the two demo fMRI datasets to use.
  Three data files are required as input.
  User specified data files must have the names generated by the FSL/FEAT
  pre-processing tool, namely \cr
  \file{filtered_func_data.nii.gz}, \file{mask.nii.gz}, and \file{design.mat}.\cr
  \file{filtered_func_data.nii.gz} specifies the dataset to be analyzed,\cr
  \file{mask.nii.gz} specifies the dataset to be used as mask. \cr
  \file{design.mat} specifies the dataset to be used as design matrix.\cr
  Typically, these datasets are obtained using the FSL/FEAT pre-processing tool,
  or other similar tool.\cr
	In \pkg{cudaBayesreg}, versions 10+, \code{read.fmrislice}
	uses the \file{design.mat} format from FSL/FEAT.\cr
	The prefix \code{fbase} applies to the demo data files provided in the
	 complementary package \pkg{cudaBayesregData}:\cr
	\file{\{fbase\}_filtered_func.nii.gz}, \cr
	\file{\{fbase\}_mask.nii.gz},	and \cr
	\file{\{fbase\}_design.mat}.\cr
	Two test datasets are included in the package: one with prefix \samp{fmri},
		the other with prefix \samp{swrfM}.
	The prefix \samp{swrfM} is used in the random effects example.
	See also \code{read.Zsegslice} for user-defined segmented masks.}
\item{R}{number of MCMC draws}
\item{keep}{MCMC thinning parameter: keep every keepth draw (def: 5)}
\item{nu.e}{d.f. parameter for regression error variance prior (def: 3)}
\item{zprior}{Boolean \{T,F\}; default \{F\} - use just a mean for \code{Z}
   (see model description in \code{cudaMultireg.slice}. }
\item{rng}{integer \{0,1,2\}: type of RNG to use \{0-Marsaglia Multicarry,
    1-R. P. Brent xorgens, 2-Mersenne Twister MT19937-64\}; (def. 0-Marsaglia Multicarry)}
\item{rg}{rg=c(first, last): a vector containing the first and last numbers
    of the sequence of slices to be processed.
    If rg=c(NULL,NULL) (default), all slices in the volume are processed.}
\item{swap}{ logical variable (default = \code{FALSE}) for choosing the
    right/left data display convention consistent with FSLVIEW } 
\item{savedir}{Directory (def: \code{tempdir()}) were the MCMC simulations for all slices are
    going to be saved.}
}
\details{
  The statistical model implemented in CUDA was specified as a Gibbs Sampler for hierarchical linear models
  with a normal prior.
  The main computational work is done in parallel on a CUDA capable GPU. Each thread is responsible for fitting
  a general linear model at each voxel.
  Data volumes are processed on a slice-by-slice basis, before reconstructing the processed volume,
  using \code{build.zstatvolume}.
  The statistical model is specified in \code{cudaMultireg.slice}. 
  To run the examples, the data sets from the R-package \pkg{cudaBayesregData} are required.
}
\author{ Adelino Ferreira da Silva, Universidade Nova de Lisboa, Faculdade de Ciencias e Tecnologia, Portugal, \email{afs@fct.unl.pt}.
}
\references{
Adelino Ferreira da Silva (2011), \emph{A Bayesian Multilevel Model for fMRI Data Analysis}, Computer Methods and Programs in Biomedicine, 102, 238-252.

Adelino Ferreira da Silva (2010), \emph{cudaBayesreg: Bayesian Computation in CUDA}, The R Journal, 2/2, 48-55.

Rossi, Allenby and McCulloch, \emph{Bayesian Statistics and Marketing}, Chapter 3.\cr
\url{http://faculty.chicagogsb.edu/peter.rossi/research/bsm.html}

Davies, R.B. (1994) \emph{Writing a matrix package in C++}. In OON-SKI'94: The second annual object-oriented numerics conference,
207-213. Rogue Wave Software, Corvallis.\cr 
\url{http://www.robertnz.net/cpp\_site.html}.

Richard. P. Brent, \emph{Some long-period random number generators using shifts and xors}, Preprint: 2 July 2007.

Brandon Whitcher, Volker Schmid and Andrew Thornton (2011), R package \pkg{oro.nifti}: Rigorous - NIfTI Input / Output, R package version 0.2.5,\cr
\url{http://CRAN.R-project.org/package=oro.nifti}.
}

\seealso{
  \code{\link{cudaMultireg.slice}},
  \code{\link{buildzstat.volume}},
  \code{\link{read.fmrislice}},
  \code{\link{read.Zsegslice}},
  \code{\link{premask}},
  \code{\link{pmeans.hcoef}},
  \code{\link{regpostsim}},
  \code{\link{plot.hcoef.post}},
  \code{\link{post.simul.hist}},
  \code{\link{post.ppm}},
  \code{\link{post.tseries}},
  \code{\link{post.randeff}},
  \code{\link{post.shrinkage.mean}}
}

\examples{
\dontrun{
## simulation using the SPM auditory dataset "swrfM*" 
cudaMultireg.volume(fbase="swrfM", R=2000, rg=c(13,16), savedir=tempdir())
buildzstat.volume(fbase="swrfM", rg=c(13,16))
post.overlay(fbase="swrfM", vreg=2, rg=c(13,16), view="axial")
##
## Random effects simulation using the SPM auditory dataset "swrfM*" 
cudaMultireg.volume(fbase="swrfM", R=2000, zprior=TRUE, rng=1,
  rg=c(17,21),  savedir=tempdir())
buildzstat.volume(fbase="swrfM", rg=c(17,21))
post.overlay(fbase="swrfM", vreg=2, rg=c(17,21), view="axial")
##
## Simulation using the visual/auditory test dataset "fmri"  
cudaMultireg.volume(fbase="fmri", R=2000, savedir=tempdir())
buildzstat.volume(fbase="fmri", vreg=2)
post.overlay(fbase="fmri", vreg=2, view="axial")
buildzstat.volume(fbase="fmri", vreg=4)
post.overlay(fbase="fmri", vreg=4, view="axial")
}
}
\keyword{ regression }
