\name{swrfM_design}
\alias{swrfM_design}
\docType{data}
\title{Example of design matrix for the real SPM auditory dataset}
\description{
  FMRI analysis requires the specification of the design matrix to be used in processing the general linear model. 
  The design matrix defines the experimental design and the nature of hypothesis testing to be implemented.
  The design matrix has one row for each scan and one column for each effect or explanatory variable (regressor or stimulus function). 
  The design matrix is used in fMRI analysis to specify the basis functions modeling the hemodynamic response function (HRF).
  It could be based on a single basis function or a set of functions.
  Two common basis function models are: (1) a single basis function is used for each explanatory variable;
  (2) a second time derivative basis functions is added to model (1), for each explanatory variable.
  The design matrix \file{swrfM_design.txt} follows model (2) above for the auditory explanatory variable
  (2 regressors, excluding the intercept) .
  This design matrix goes with the file \file{swrfM_filtered_func_data.nii.gz} used in the examples.
  The file \file{swrfM_filtered_func_data.nii.gz} included in the package is a pre-processed file in
  gzipped NIFTI format of the auditory fMRI data set available from the SPM site (\url{http://www.fil.ion.ucl.ac.uk/spm/}).
  Note that \code{cudaMultireg.slice} includes an additional intercept variable for regression. 
  Therefore the explanatory variable of interest for brain visualization purposes in Posterior Probability Mapping (PPM)
  is variable number 2 (referenced as \samp{vreg=2}).
}
\format{
  The file \file{swrfM_design.txt} used is a data frame with 84 observations on the following 2 explanatory variables: auditory,
  auditory temporal derivative.
  The file  \file{swrfM_design.txt} is based on the file \file{design.mat} generated by the FSL/FEAT tool. 
  Similar procedures for generating design matrices for fMRI datasets are available in the SPM toolbox (\url{http://www.fil.ion.ucl.ac.uk/spm/}).
}
\references{
	\emph{SPM8 Manual}, John Ashburner et. al., Functional Imaging Laboratory,
	Institute of Neurology, UCL, London, (\url{http://www.fil.ion.ucl.ac.uk/spm/})
}
\keyword{datasets}
