% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nslookup.R
\name{nslookup}
\alias{nslookup}
\alias{has_internet}
\title{Lookup a hostname}
\usage{
nslookup(host, error = TRUE)

has_internet()
}
\arguments{
\item{host}{a string with a hostname}

\item{error}{raise an error for failed DNS lookup. Otherwise returns \code{NULL}.}
}
\description{
The \code{nslookup} function is similar to \code{nsl} but works on all platforms
and can resolve ipv6 addresses if supported by the OS. Default behavior raises an
error if lookup fails. The \code{has_internet} function tests the internet
connection by resolving a random address.
}
\examples{
# Should always work if we are online
nslookup("www.r-project.org")

# If your OS supports IPv6
nslookup("ipv6.test-ipv6.com", error = FALSE)
}

