% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_metric.R
\name{plot_metric}
\alias{plot_metric}
\title{Plot a metric over all possible cutoffs from a cutpointr object}
\usage{
plot_metric(x, conf_lvl = 0.95, add_unsmoothed = TRUE)
}
\arguments{
\item{x}{A cutpointr object.}

\item{conf_lvl}{The confidence level of the bootstrap confidence interval.
Set to 0 to draw no bootstrap confidence interval.}

\item{add_unsmoothed}{Add the line of unsmoothed metric values to the plot.
Applicable for some smoothing methods, e.g. maximize_gam_metric.}
}
\description{
If \code{maximize_metric} is used as \code{method} function in cutpointr the computed
metric values over all possible cutoffs can be plotted. Generally, this
works for method functions that return a ROC-curve including the metric
value for every cutpoint along with the optimal cutpoint.
}
\examples{
opt_cut <- cutpointr(suicide, dsi, suicide)
plot_metric(opt_cut)
}
\seealso{
Other cutpointr plotting functions: 
\code{\link{plot.cutpointr}()},
\code{\link{plot_cut_boot}()},
\code{\link{plot_cutpointr}()},
\code{\link{plot_metric_boot}()},
\code{\link{plot_precision_recall}()},
\code{\link{plot_roc}()},
\code{\link{plot_sensitivity_specificity}()},
\code{\link{plot_x}()}

Other cutpointr plotting functions: 
\code{\link{plot.cutpointr}()},
\code{\link{plot_cut_boot}()},
\code{\link{plot_cutpointr}()},
\code{\link{plot_metric_boot}()},
\code{\link{plot_precision_recall}()},
\code{\link{plot_roc}()},
\code{\link{plot_sensitivity_specificity}()},
\code{\link{plot_x}()}
}
\concept{cutpointr plotting functions}
