% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-Myriophyllum.R
\name{Myrio_log}
\alias{Myrio_log}
\alias{MyrioLogScenario-class}
\title{Myriophyllum model with logistic growth}
\usage{
Myrio_log()
}
\value{
an S4 object of type \linkS4class{MyrioLogScenario}
}
\description{
The \emph{Myriophyllum} model is derived from the \emph{Lemna} TKTD model
by Klein \emph{et al.} (2021).
\code{Myrio_log()} modifies the \code{\link[=Myrio]{Myrio()}} model to feature logistic growth, i.e.
control growth is described by the differential equation
\verb{d BM/dt = k_photo_max*BM*(1 - BM/BM_L)} where \code{BM_L} is the carrying capacity.
}
\section{Model parameters}{

\itemize{
\item Growth model
\itemize{
\item \code{k_photo_max}, Maximum photosynthesis rate (d-1), default: \code{0.47}
\item \code{BM_L}, Carrying capacity (g dw m-2)
}
\item Concentration response (Toxicodynamics)
\itemize{
\item \code{EC50_int}, Internal concentration resulting in 50\% effect (ug L-1)
\item \code{E_max}, Maximum inhibition (-), default: \code{1}
\item \code{b}, Slope parameter (-)
}
\item Internal concentration (Toxicokinetics)
\itemize{
\item \code{P}, Permeability (cm d-1)
\item \code{r_A_DW}, Area per dry-weight ratio (cm2 g-1), default: \code{1000}
\item \code{r_FW_DW}, Fresh weight per dry weight ratio (-), default: \code{16.7}
\item \code{r_FW_V}, Fresh weight density (g cm-3), default: \code{1}
\item \code{r_DW_TSL}, Dry weight per total shoot length ratio  (?)
\item \code{K_pw}, Partitioning coefficient plant:water (-), default: \code{1}
\item \code{k_met}, Metabolisation rate (d-1), default: \code{0}
}
}
}

\section{State variables}{

The model has two state variables:
\itemize{
\item \code{BM}, Biomass (g dw m-2)
\item \code{M_int}, Mass of toxicant in plant population (mass per m2, e.g. ug m-2)
}
}

\section{Environmental factors}{


None.
}

\section{Simulation output}{


Simulation results will contain two additional columns besides state variables:
\itemize{
\item \code{C_int}, internal concentration of toxicant (mass per volume)
\item \code{TSL}, total shoot length (?)
}

The available output levels are as follows:
\itemize{
\item \code{nout >= 1}
\itemize{
\item \code{C_int}, internal concentration (mass per volume)
}
\item \code{nout >= 2}
\itemize{
\item \code{TSL}, total shoot length (?)
}
\item \code{nout >= 3}
\itemize{
\item \code{f_photo}, photosynthesis dependency function (-)
}
\item \code{nout >= 5}, growth and TK/TD
\itemize{
\item \code{C_int_unb}, unbound internal concentration (mass per volume)
\item \code{C_ext}, external concentration (mass per volume)
}
\item \code{nout >= 7}, environmental factors
\itemize{
\item \code{dBM}, biomass derivative (g dw m-2 d-1)
\item \code{dM_int}, mass of toxicant in plants derivative (mass per m2 d-1)
}
}
}

\section{Effects}{

Supported effect endpoints include \emph{BM} (biomass) and \emph{r} (average
growth rate during simulation). The effect on biomass is calculated from
the last state of a simulation. Be aware that endpoint \emph{r} is incompatible
with biomass transfers.
}

\section{Biomass transfer}{

Models supporting biomass transfer can be instructed to move a fixed amount
of biomass to a new medium after a period of time. This feature replicates
a procedure occurring in e.g. Lemna effect studies and may be necessary to
recreate study results.

The biomass transfer feature assumes that always a fixed amount of
biomass is transferred. Transfers can occur at any fixed point in time or
in regular intervals. During a transfer, the biomass is reset to the
transferred amount and additional compartments can be scaled 1:1 accordingly,
to e.g. reflect the change in internal toxicant mass when biomass is modified.
Transfer settings can be modified using \code{\link[=set_transfer]{set_transfer()}}.

Any transfer time point must also be an output time point. If a transfer
occurs, simulation results of that time point will report the model state
\strong{before} the transfer. Be aware that in order to use transfers at regular
intervals, the simulation must start at time point zero.
}

\references{
Klein J., Cedergreen N., Heine S., Reichenberger S., Rendal C.,
Schmitt W., Hommen U., 2021: \emph{Refined description of the Lemna TKTD growth model
based on Schmitt et al. (2013) - equation system and default parameters}.
Report of the working group \emph{Lemna} of the SETAC Europe Interest Group Effect
Modeling. Version 1, uploaded on 22. Sept. 2021.
https://www.setac.org/group/effect-modeling.html
}
\seealso{
\link{Transferable}, \link{Scenarios}

Other Myriophyllum models: 
\code{\link{Myrio}()},
\code{\link{Myriophyllum-models}}

Other macrophyte models: 
\code{\link{Lemna_SETAC}()},
\code{\link{Lemna_Schmitt}()},
\code{\link{Macrophyte-models}},
\code{\link{Myrio}()}
}
\concept{Myriophyllum models}
\concept{macrophyte models}
