% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_tag}
\alias{get_tag}
\alias{get_tag,ANY-method}
\alias{get_tag,list-method}
\alias{get_tag,EffectScenario-method}
\alias{get_tag,parameter_set-method}
\title{Get scenario tag}
\usage{
get_tag(x)
}
\arguments{
\item{x}{(vector of) \link{scenarios} or \code{\link{parameter_set}} objects}
}
\value{
vector of \code{character}
}
\description{
Returns the user-defined, custom tag of a scenario, if available. Tags
can be helpful to quickly distinguish scenarios of the same model type.
The function supports vectorized inputs.
}
\examples{
# returns `fathead minnow`
get_tag(minnow_it)

# update or set a tag
myscenario <- minnow_it \%>\% set_tag("My Custom Tag")
# returns `My Custom Tag`
get_tag(myscenario)
}
\seealso{
\code{\link[=set_tag]{set_tag()}}
}
