% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lik_profile.R
\name{log_lik}
\alias{log_lik}
\title{Calculate log likelihood}
\usage{
log_lik(npars, obs, pred)
}
\arguments{
\item{npars}{named numeric vector of parameters that the model was calibrated on}

\item{obs}{numeric vector of observed values}

\item{pred}{numeric vector of predicted values}
}
\value{
the log likelihood value
}
\description{
Calculates the sum of log likelihoods of each observation given
the model parameterization (considering a normal distribution around the prediction
for each datapoint)
}
\examples{

# observations
obs <- c(12, 38, 92, 176, 176, 627, 1283, 2640)
# intercept, a, and slope, b, of a Poisson regression fitted through obs
pars <- c(a = 2, b = 0.73)
# predictions with the Poisson regression
pred <- c(15.43, 32.15, 66.99, 139.57, 290.82, 605.94, 1262.52, 2630.58)
# example plot
plot(seq(1:length(obs)), obs)
lines(seq(1:length(obs)), pred)
log_lik(
  npars = length(pars),
  obs = obs,
  pred = pred
)

}
