% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator}
\alias{cvd_indicator}
\title{Indicators}
\usage{
cvd_indicator(time_period_id = 1, area_id = 1, tag_id)
}
\arguments{
\item{time_period_id}{integer - time period to return data for (compulsory)}

\item{area_id}{integer - area to return data for (compulsory)}

\item{tag_id}{numeric vector - allows filtering indicators by one or more tags (optional, array)}
}
\value{
List of named tibbles (indicators, categories, category_data, timeseries_data, all_data)
}
\description{
Returns all indicators and data for a given time period and area. Also returns
time series data for all time periods available. If tags are specified, only
indicators which have one of the specified tags will be returned.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator}{Indicator}
}
\examples{
# Returns a list of named tibbles. To use we need to unpack the list:
return_list <- cvd_indicator(time_period_id = 17, area_id = 1103)

# See what the list contains
return_list |> summary()

# extract the indicators
indicators <- return_list$indicators
indicators |>
  dplyr::select(IndicatorID, IndicatorCode, IndicatorShortName) |>
  dplyr::arrange(IndicatorID) |>
  dplyr::slice_head(n = 4)

# extract the metric categories
categories <- return_list$metric_categories
categories |>
  dplyr::filter(IndicatorID == 7, MetricCategoryID \%in\% c(7, 8)) |>
  dplyr::select(IndicatorID, MetricCategoryTypeName,
  CategoryAttribute, MetricCategoryName, MetricID)

# extract metric data
metric_data <- return_list$metric_data
metric_data |>
  dplyr::filter(MetricID \%in\% c(126, 132)) |>
  dplyr::select(MetricID, Value, Numerator, Denominator)

# extract the time series data
timeseries_data <- return_list$timeseries_data
timeseries_data |>
  dplyr::filter(MetricID \%in\% c(126, 132), !is.na(Value))

# indicators are searcheable by one or more Tag.
return_list <-
  cvd_indicator(time_period_id = 17, area_id = 3, tag_id = c(3, 4))
}
\seealso{
\code{\link[=cvd_indicator_list]{cvd_indicator_list()}}, \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}},
\code{\link[=cvd_indicator_tags]{cvd_indicator_tags()}}, \code{\link[=cvd_indicator_details]{cvd_indicator_details()}}, \code{\link[=cvd_indicator_sibling]{cvd_indicator_sibling()}},
\code{\link[=cvd_indicator_child_data]{cvd_indicator_child_data()}}, \code{\link[=cvd_indicator_data]{cvd_indicator_data()}}, \code{\link[=cvd_indicator_metric_data]{cvd_indicator_metric_data()}},
\code{\link[=cvd_indicator_raw_data]{cvd_indicator_raw_data()}}, \code{\link[=cvd_indicator_nationalarea_metric_data]{cvd_indicator_nationalarea_metric_data()}},
\code{\link[=cvd_indicator_priority_groups]{cvd_indicator_priority_groups()}}, \code{\link[=cvd_indicator_pathway_group]{cvd_indicator_pathway_group()}}, #
\code{\link[=cvd_indicator_group]{cvd_indicator_group()}}, \code{\link[=cvd_indicator_metric_timeseries]{cvd_indicator_metric_timeseries()}},
\code{\link[=cvd_indicator_person_timeseries]{cvd_indicator_person_timeseries()}}, \code{\link[=cvd_indicator_metric_systemlevel_comparison]{cvd_indicator_metric_systemlevel_comparison()}},
\code{\link[=cvd_indicator_metric_area_breakdown]{cvd_indicator_metric_area_breakdown()}}
}
