% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_priority_groups}
\alias{cvd_indicator_priority_groups}
\title{Indicator priority groups}
\usage{
cvd_indicator_priority_groups()
}
\value{
Tibble of indicators grouped by priority group
}
\description{
Returns the list of top-level groupings (Priority Groups) displayed in the
Regional & ICS Insights page. Returns a dictionary called 'PriorityGroups'
with each key being a Priority Group name, and each value being the array of
indicators contained in that group. The 'PriorityGroupDisplayOrder'
indicates the order in which it should be displayed for the given Priority
Group.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2FpriorityGroups}{Indicator priority groups}
}
\examples{
# Return one indicator from each of the priority groups:
cvd_indicator_priority_groups() |>
  dplyr::select(PriorityGroup, PathwayGroupName, PathwayGroupID,
  IndicatorCode, IndicatorID, IndicatorName) |>
  dplyr::slice_head(by = PathwayGroupID)
}
\seealso{
\code{\link[=cvd_indicator_list]{cvd_indicator_list()}}, \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}}, \code{\link[=cvd_indicator]{cvd_indicator()}},
\code{\link[=cvd_indicator_tags]{cvd_indicator_tags()}}, \code{\link[=cvd_indicator_details]{cvd_indicator_details()}}, \code{\link[=cvd_indicator_sibling]{cvd_indicator_sibling()}},
\code{\link[=cvd_indicator_child_data]{cvd_indicator_child_data()}}, \code{\link[=cvd_indicator_data]{cvd_indicator_data()}}, \code{\link[=cvd_indicator_metric_data]{cvd_indicator_metric_data()}},
\code{\link[=cvd_indicator_raw_data]{cvd_indicator_raw_data()}}, \code{\link[=cvd_indicator_nationalarea_metric_data]{cvd_indicator_nationalarea_metric_data()}},
\code{\link[=cvd_indicator_pathway_group]{cvd_indicator_pathway_group()}},
\code{\link[=cvd_indicator_group]{cvd_indicator_group()}}, \code{\link[=cvd_indicator_metric_timeseries]{cvd_indicator_metric_timeseries()}},
\code{\link[=cvd_indicator_person_timeseries]{cvd_indicator_person_timeseries()}}, \code{\link[=cvd_indicator_metric_systemlevel_comparison]{cvd_indicator_metric_systemlevel_comparison()}},
\code{\link[=cvd_indicator_metric_area_breakdown]{cvd_indicator_metric_area_breakdown()}}
}
