% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_area_system_level_time_periods}
\alias{cvd_area_system_level_time_periods}
\title{List all system levels and available time periods}
\usage{
cvd_area_system_level_time_periods()
}
\value{
tibble of system levels and reporting periods
}
\description{
Returns all available system levels along with the time periods where the
system levels occur.
}
\details{
Note: this is the inverse of \code{cvd_time_period_system_levels()}.

CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#*Proposed*\%2Farea\%2FsystemLevel\%2FtimePeriods}{All system levels and time periods}
}
\examples{
# list the latest four reporting periods at GP practice level
cvd_area_system_level_time_periods() |>
  dplyr::filter(SystemLevelName == 'Practice') |>
  dplyr::slice_max(order_by = TimePeriodID, n = 4) |>
  dplyr::select(SystemLevelName, TimePeriodID, TimePeriodName)
}
\seealso{
\code{\link[=cvd_time_period_system_levels]{cvd_time_period_system_levels()}}, \code{\link[=cvd_area_details]{cvd_area_details()}}, \code{\link[=cvd_area_unassigned]{cvd_area_unassigned()}}, \code{\link[=cvd_area_search]{cvd_area_search()}}, \code{\link[=cvd_area_nested_subsystems]{cvd_area_nested_subsystems()}}, \code{\link[=cvd_area_flat_subsystems]{cvd_area_flat_subsystems()}}
}
