% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_metrics.R
\name{summarize_metrics}
\alias{summarize_metrics}
\title{Summarize metrics with common descriptors}
\usage{
summarize_metrics(data, cols = NULL, na.rm = TRUE, inf.rm = TRUE)
}
\arguments{
\item{data}{Data frame with numeric columns to summarize.}

\item{cols}{Names of columns to summarize. Non-numeric columns are ignored. (Character)}

\item{na.rm}{Whether to remove \code{NA}s before summarizing. (Logical)}

\item{inf.rm}{Whether to remove \code{Inf}s before summarizing. (Logical)}
}
\value{
Tibble where each row is a descriptor of the column.

 The \strong{Measure} column contains the name of the descriptor.

 The \strong{NAs} row is a count of the \code{NA}s in the column.

 The \strong{INFs} row is a count of the \code{Inf}s in the column.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Summarizes all numeric columns. Counts the \code{NA}s and \code{Inf}s in the columns.
}
\examples{
# Attach packages
library(cvms)
library(dplyr)

df <- data.frame("a" = c("a", "a", "a", "b", "b", "b", "c", "c", "c"),
                 "b" = c(0.8, 0.6, 0.3, 0.2, 0.4, 0.5, 0.8, 0.1, 0.5),
                 "c" = c(0.2, 0.3, 0.4, 0.6, 0.5, 0.8, 0.1, 0.8, 0.3))

# Summarize all numeric columns
summarize_metrics(df)

# Summarize column "b"
summarize_metrics(df, cols = "b")
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
