% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choosing_metrics_functions.R
\name{gaussian_metrics}
\alias{gaussian_metrics}
\title{Select metrics for Gaussian evaluation}
\usage{
gaussian_metrics(
  all = NULL,
  rmse = NULL,
  mae = NULL,
  nrmse_rng = NULL,
  nrmse_iqr = NULL,
  nrmse_std = NULL,
  nrmse_avg = NULL,
  rae = NULL,
  rse = NULL,
  rrse = NULL,
  rmsle = NULL,
  male = NULL,
  mape = NULL,
  mse = NULL,
  tae = NULL,
  tse = NULL,
  r2m = NULL,
  r2c = NULL,
  aic = NULL,
  aicc = NULL,
  bic = NULL
)
}
\arguments{
\item{all}{Enable/disable all arguments at once. (Logical)

 Specifying other metrics will overwrite this, why you can
 use (\code{all = FALSE, rmse = TRUE}) to get only the \code{RMSE} metric.}

\item{rmse}{\code{RMSE}. (Default: TRUE)

 Root Mean Square Error.}

\item{mae}{\code{MAE}. (Default: TRUE)

 Mean Absolute Error.}

\item{nrmse_rng}{\code{NRMSE(RNG)}. (Default: FALSE)

 Normalized Root Mean Square Error (by target range).}

\item{nrmse_iqr}{\code{NRMSE(IQR)}. (Default: TRUE)

 Normalized Root Mean Square Error (by target interquartile range).}

\item{nrmse_std}{\code{NRMSE(STD)}. (Default: FALSE)

 Normalized Root Mean Square Error (by target standard deviation).}

\item{nrmse_avg}{\code{NRMSE(AVG)}. (Default: FALSE)

 Normalized Root Mean Square Error (by target mean).}

\item{rae}{\code{RAE}. (Default: TRUE)

 Relative Absolute Error.}

\item{rse}{\code{RSE}. (Default: FALSE)

 Relative Squared Error.}

\item{rrse}{\code{RRSE}. (Default: TRUE)

 Root Relative Squared Error.}

\item{rmsle}{\code{RMSLE}. (Default: TRUE)

 Root Mean Square Log Error.}

\item{male}{\code{MALE}. (Default: FALSE)

 Mean Absolute Log Error.}

\item{mape}{\code{MAPE}. (Default: FALSE)

 Mean Absolute Percentage Error.}

\item{mse}{\code{MSE}. (Default: FALSE)

 Mean Square Error.}

\item{tae}{\code{TAE}. (Default: FALSE)

 Total Absolute Error}

\item{tse}{\code{TSE}. (Default: FALSE)

 Total Squared Error.}

\item{r2m}{\code{r2m}. (Default: FALSE)

 Marginal R-squared.}

\item{r2c}{\code{r2c}. (Default: FALSE)

 Conditional R-squared.}

\item{aic}{\code{AIC}. (Default: FALSE)

 Akaike Information Criterion.}

\item{aicc}{\code{AICc}. (Default: FALSE)

 Corrected Akaike Information Criterion.}

\item{bic}{\code{BIC}. (Default: FALSE)

 Bayesian Information Criterion.}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Enable/disable metrics for Gaussian evaluation. Can be supplied to the
 \code{`metrics`} argument in many of the \code{cvms} functions.

 Note: Some functions may have slightly different defaults than the ones supplied here.
}
\examples{
\donttest{
# Attach packages
library(cvms)

# Enable only RMSE
gaussian_metrics(all = FALSE, rmse = TRUE)

# Enable all but RMSE
gaussian_metrics(all = TRUE, rmse = FALSE)

# Disable RMSE
gaussian_metrics(rmse = FALSE)
}
}
\seealso{
Other evaluation functions: 
\code{\link{binomial_metrics}()},
\code{\link{confusion_matrix}()},
\code{\link{evaluate_residuals}()},
\code{\link{evaluate}()},
\code{\link{multinomial_metrics}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{evaluation functions}
