% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hullMesh.R
\name{hullMesh}
\alias{hullMesh}
\title{Mesh of a 3d convex hull}
\usage{
hullMesh(hull, simplify = TRUE)
}
\arguments{
\item{hull}{a 3d convex hull, output of \code{\link{cxhull}}}

\item{simplify}{Boolean, whether to return the faces as a matrix instead 
of a list if possible, i.e. when all faces have the same number of sides}
}
\value{
A list giving the vertices and the faces.
}
\description{
Extract the vertices and the faces from a 3d convex hull.
}
\note{
Unless all faces are triangular, the output does not define a mesh 
  with coherently oriented faces. If you want correct face orientations, 
  you can use the \strong{PolygonSoup} package.
}
\examples{
library(cxhull)
hull <- cxhull(daVinciSphere)
septuaginta <- hullMesh(hull)
}
