% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs4_nc.R
\name{bs4_nc}
\alias{bs4_nc}
\title{gates out or assign indicators to BS4 cyanobacteria cells.}
\usage{
bs4_nc(bs4bs5, p1, p2, others, to_retain = c("refined", "potential"))
}
\arguments{
\item{bs4bs5}{flowframe with debris removed.}

\item{p1}{first flowcytometer channel that can be used to separate BS4 cells from the rest, e.g. "RED.B.HLin".}

\item{p2}{second flowcytometer channel that can be used to separate BS4 cells from the rest, e.g. "YEL.B.HLin"}

\item{others}{row numbers for non-debris events. This is provided by the \code{\link{debris_nc}} or \code{\link{debris_inc}} function.}

\item{to_retain}{should potential candidates be retained or further gating be applied to filter out only certain BS4 cells.}
}
\value{
list containing; \itemize{
\item \strong{bs4_reduced -} flowframe containing only BS4s
\item \strong{others_nk -} unidentified particle positions
\item \strong{bs4_pos -} BS4 positions
\item \strong{others_nk2 -} other unidentified particle positions
}
}
\description{
This function takes in a flowframe with debris removed and identifies BS4 populations in the provided frame.
}
\details{
The function uses the \code{\link[flowDensity]{getPeaks}} and \code{\link[flowDensity]{deGate}} functions in the \emph{flowDensity} package to
         identify peaks and identify cut-off points between these peaks. This function is not designed to be called in isolation, if called
         in isolation an error will be returned. It is preferably called on the results from \code{\link{debris_nc}} or \code{\link{debris_inc}} function. A graph with horizontal
         and vertical lines used in separating the populations is returned and if \emph{to_retain = "potential"}, all BS4 points are coloured red while a
         circle made of dashed lines is drawn around BS4 points if \emph{to_retain = "refined"}.
}
\seealso{
\code{\link{bs5_nc}}
}
