% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRhoDelta.R
\name{findDelta}
\alias{findDelta}
\alias{findRho}
\alias{DeltaToRho}
\title{Converting between Rho to Delta}
\usage{
findDelta(rho)

findRho(delta)

DeltaToRho(delta, rho)
}
\arguments{
\item{rho}{concentration parameter on interval [0, 1]}

\item{delta}{duration parameter}
}
\value{
duration parameter delta

concentration parameter rho on interval [0, 1]
}
\description{
Functions for converting the concentration parameter rho to the season 
duration parameter delta and vice versa.  They are: \code{findDelta(rho)}.  
These are mainly internal.
}
\examples{
findDelta(rho = 0.9); findRho(0.0167)
findDelta(rho = 0.1); findRho(0.218)
 
# Plot the relationship
oldpar <- par(no.readonly = TRUE)
par(mfrow = c(1,2))
rhos <- seq(0, 1, length = 1e3)
plot(rhos, findDelta(rhos), ylab = "deltas", type = "l")
deltas <- seq(0, .5, length = 1e3)
plot(deltas, findRho(deltas), ylab = "rhos", type = "l")
par(oldpar)
}
