% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_trajectory.R
\name{make_traj}
\alias{make_traj}
\title{Generate a Trajectory with Correlated Step Lengths and Turn Angles}
\usage{
make_traj(
  n,
  copula,
  marginal_circ = c("vonmises", "wrappedcauchy", "mixedvonmises", "dens"),
  parameter_circ,
  marginal_lin,
  parameter_lin,
  pos_2 = c(1, 0)
)
}
\arguments{
\item{n}{\link[base]{integer}, number of trajectory steps to generate.}

\item{copula}{'\code{\linkS4class{cyl_copula}}' object.}

\item{marginal_circ}{\link[base]{character} string denoting the name of the circular
distribution. It can be \code{"vonmises"}, \code{"mixedvonmises"},
\code{"wrappedcauchy"}, or \code{"dens"} (for kernel density estimate).}

\item{parameter_circ}{(named) \link[base]{list} of parameters of the circular
marginal distribution as taken by the functions
\code{\link[circular]{qvonmises}()}, \code{\link{qmixedvonmises}()},
or \code{\link{qwrappedcauchy}()}. If \code{marginal_circ = "dens"},
\code{parameter_circ} must be a named \link[base]{list}, containing information
on the kernel density estimate, which can be obtained
using \code{\link{fit_angle}(...,parametric = FALSE)}.}

\item{marginal_lin}{\link[base]{character} string denoting the name of the
linear distribution, i.e. the name of its distribution function without the "p",
  e.g. "norm" for normal distribution, or \code{"dens"} (for kernel density estimate).}

\item{parameter_lin}{(named) \link[base]{list} of parameters of the linear
marginal distribution. For \code{marginal_lin = "dens"}, \code{parameter_lin}
 must be a named \link[base]{list}, containing information
on the kernel density estimate, which can be obtained
using \code{\link{fit_steplength}(...,parametric = FALSE)}.}

\item{pos_2}{\link[base]{numeric} \link[base]{vector} containing the coordinates
of the second point in the trajectory. The first point is always at (0,0).}
}
\value{
A \link[base]{data.frame} containing the trajectory. It has 6 columns
containing the x and y coordintates, the step lengths, the turn angles, and
the values sampled from the copula.
}
\description{
The function draws values from a circular-linear bivariate distribution of
turn angles and step lengths specified by the marginal distributions and a
circular-linear copula. Samples are drawn from the copula and then transformed
using the quantile functions of the marginal distributions. From the start
point (0,0) and the second (user specified)
point, a trajectory is then built with these turn angles and step lengths.
}
\examples{
require(circular)
set.seed(123)

traj <- make_traj(5,
  copula = cyl_quadsec(0.1),
  marginal_circ = "vonmises",
  parameter_circ = list(0, 1),
  marginal_lin = "weibull",
  parameter_lin = list(shape=3)
)
traj

angles <- circular::rmixedvonmises(100,
  mu1 = circular::circular(0),
  mu2 = circular::circular(pi),
  kappa1 = 2,
  kappa2 = 3,
  prop = 0.4
)
angles <- full2half_circ(angles)
bw <- opt_circ_bw(theta = angles,loss = "adhoc", kappa.est = "trigmoments")
dens <- fit_angle(theta = angles, parametric = FALSE, bandwidth = bw)
make_traj(5,
  copula = cyl_quadsec(0.1),
  marginal_circ = "dens",
  parameter_circ = dens,
  marginal_lin = "weibull",
  parameter_lin = list(shape=3),
  pos_2 = c(5,5)
)

}
\seealso{
\code{\link{fit_steplength}()}, \code{\link{fit_angle}()},
\code{\link{traj_plot}()}, \code{\link{cop_scat_plot}()},
\code{\link{scat_plot}()}, \code{\link{circ_plot}()}.
}
