% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asn.R
\name{bulk_peer}
\alias{bulk_peer}
\title{Retrieves BGP Peer ASN info for a list of IPv4 addresses}
\usage{
bulk_peer(ips, timeout = getOption("timeout"))
}
\arguments{
\item{ips}{vector of IPv4 address (character - dotted-decimal)}

\item{timeout}{numeric: the timeout (in seconds) to be used for this connection.
Beware that some OSes may treat very large values as zero: however the
POSIX standard requires values up to 31 days to be supported.}
}
\value{
data frame of BGP Peer ASN lookup results
  \itemize{
    \item \code{peer_as} - peer AS #
    \item \code{ip} - IPv4 (passsed in)
    \item \code{bgp_prefix} - BGP CIDR block
    \item \code{cc} - Country code
    \item \code{registry} - Registry it falls under
    \item \code{allocated} - date allocated
    \item \code{peer_as_name} - peer name
  }
  If a socket connection cannot be made (i.e. a network problem on your
  end or a service/network problem on their end), all columns will be
  \code{NA}.
}
\description{
Retrieves BGP Peer ASN info for a list of IPv4 addresses
}
\note{
The Team Cymru's service is NOT a GeoIP service! Do not use this
      function for that as your results will not be accurate.
      Data is updated every 4 hours. Also,
      A direct connection to TCP Port 43 (WHOIS) is required for most of these
      API functions to work properly.
}
\examples{
\dontrun{
bulk_peer(c("68.22.187.5", "207.229.165.18", "198.6.1.65"))
}
}
\seealso{
\url{http://www.team-cymru.org/IP-ASN-mapping.html}
}

