% Generated by roxygen2 (4.0.1): do not edit by hand
\name{d3SimpleNetwork}
\alias{d3SimpleNetwork}
\title{Function for creating simple D3 JavaScript force directed network graphs.}
\source{
D3.js was created by Michael Bostock. See \url{http://d3js.org/} and, more
specifically for directed networks
\url{https://github.com/mbostock/d3/wiki/Force-Layout}
}
\usage{
d3SimpleNetwork(Data, Source = NULL, Target = NULL, height = 600,
  width = 900, fontsize = 7, linkDistance = 50, charge = -200,
  linkColour = "#666", nodeColour = "#3182bd",
  nodeClickColour = "#E34A33", textColour = "#3182bd", opacity = 0.6,
  parentElement = "body", standAlone = TRUE, file = NULL,
  iframe = FALSE, d3Script = "http://d3js.org/d3.v3.min.js")
}
\arguments{
\item{Data}{a data frame object with three columns. The first two are the
names of the linked units. The third records an edge value. (Currently the
third column doesn't affect the graph.)}

\item{Source}{character string naming the network source variable in the data
frame. If \code{Source = NULL} then the first column of the data frame is
treated as the source.}

\item{Target}{character string naming the network target variable in the data
frame. If \code{Target = NULL} then the second column of the data frame is
treated as the target.}

\item{height}{numeric height for the network graph's frame area in pixels.}

\item{width}{numeric width for the network graph's frame area in pixels.}

\item{fontsize}{numeric font size in pixels for the node text labels.}

\item{linkDistance}{numeric distance between the links in pixels (actually
arbitrary relative to the diagram's size).}

\item{charge}{numeric value indicating either the strength of the node
repulsion (negative value) or attraction (positive value).}

\item{linkColour}{character string specifying the colour you want the link
lines to be. Multiple formats supported (e.g. hexadecimal).}

\item{nodeColour}{character string specifying the colour you want the node
circles to be. Multiple formats supported (e.g. hexadecimal).}

\item{nodeClickColour}{character string specifying the colour you want the
node circles to be when they are clicked. Also changes the colour of the
text. Multiple formats supported (e.g. hexadecimal).}

\item{textColour}{character string specifying the colour you want the text to
be before they are clicked. Multiple formats supported (e.g. hexadecimal).}

\item{opacity}{numeric value of the proportion opaque you would like the
graph elements to be.}

\item{parentElement}{character string specifying the parent element for the
resulting svg network graph. This effectively allows the user to specify
where on the html page the graph will be placed. By default the parent
element is \code{body}.}

\item{standAlone}{logical, whether or not to return a complete HTML document
(with head and foot) or just the script.}

\item{file}{a character string of the file name to save the resulting graph.
If a file name is given a standalone webpage is created, i.e. with a header
and footer. If \code{file = NULL} then result is returned to the console.}

\item{iframe}{logical. If \code{iframe = TRUE} then the graph is saved to an
external file in the working directory and an HTML \code{iframe} linking to
the file is printed to the console. This is useful if you are using Slidify
and many other HTML slideshow framworks and want to include the graph in the
resulting page. If you set the knitr code chunk \code{results='asis'} then
the graph will be rendered in the output. Usually, you can use
\code{iframe = FALSE} if you are creating simple knitr Markdown or HTML
pages. Note: you do not
need to specify the file name if \code{iframe = TRUE}, however if you do, do
not include the file path.}

\item{d3Script}{a character string that allows you to specify the location of
the d3.js script you would like to use. The default is
\url{http://d3js.org/d3.v3.min.js}.}
}
\description{
\code{d3SimpleNetwork} creates simple D3 JavaScript force directed network
graphs.
}
\examples{
# Fake data
Source <- c("A", "A", "A", "A", "B", "B", "C", "C", "D")
Target <- c("B", "C", "D", "J", "E", "F", "G", "H", "I")
NetworkData <- data.frame(Source, Target)

# Create graph
d3SimpleNetwork(NetworkData, height = 300, width = 700,
                 fontsize = 15)
}

