RbootCV <- function(n,MaxLag,b,parallel=FALSE){
 x <- rnorm(n)
 if (missing(MaxLag) || MaxLag < 0)
      stop("'MaxLag' must be greater than 1")
 A0 <- crossDist(x,lags=0)$A[[1]]
 Atilde0 <- ATilde(A0)
 rstar <- function(k){
  cross <- crossDist(x,lags=k)
  A <- cross$A[[1]]
  B <- cross$B[[1]]
  Atilde <- ATilde(A)
  Btilde <- ATilde(B)
  Rstark = function(Atilde,Btilde,k){
   Wtstar <- rbind(rnorm(n-k))
   dcov <- sqrt((Wtstar%*%(Atilde*Btilde)%*%t(Wtstar))/((n-k)^2))
   dvarx <- sqrt(mean((Atilde0*Atilde0))*mean((Atilde0*Atilde0)))
   return(dcov/sqrt(dvarx))
  }
 return(replicate(b,Rstark(Atilde,Btilde,k)))
}
if(parallel==TRUE){
  closeAllConnections()
#  cl <- makeCluster(detectCores())
  cl <- makeCluster(2)
  registerDoParallel(cl)
  clusterSetRNGStream(cl = cl, iseed = 9182)
  i <- 1:MaxLag
  fe_call <- as.call( c(list (as.name("foreach"), i = i,.export=c("crossDist","ATilde")) ))
  fe <- eval(fe_call)
  Rstar <- fe %dopar% rstar(i)
  stopCluster(cl)
  quant <- sapply(1:MaxLag,FUN=function(j) quantile(Rstar[[j]],0.95))
  pv <- sapply(1:MaxLag,FUN=function(j) mean(Rstar[[j]]>=quant[j]))
  pvadj <- sapply(1:MaxLag,FUN=function(j) p.adjust(pv[j],method="fdr"))
  cvadj <- sapply(1:MaxLag,FUN=function(j) quantile(Rstar[[j]],1-pvadj[j]))
  res <- max(cvadj)
}
else {
 Rstar <- lapply(1:MaxLag,FUN=function(j) rstar(j))
 quant <- sapply(1:MaxLag,FUN=function(j) quantile(Rstar[[j]],0.95))
 pv <- sapply(1:MaxLag,FUN=function(j) mean(Rstar[[j]]>=quant[j]))
 pvadj <- sapply(1:MaxLag,FUN=function(j) p.adjust(pv[j],method="fdr"))
 cvadj <- sapply(1:MaxLag,FUN=function(j) quantile(Rstar[[j]],1-pvadj[j]))
 res <- max(cvadj)
}
return(res)
}




