% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.input_data.R
\name{read_reference}
\alias{read_reference}
\title{Read reference files}
\usage{
read_reference(
  sample.table,
  system = NULL,
  file.location = ".",
  reference.quality = 0.5,
  eps = NULL,
  minPts = NULL
)
}
\arguments{
\item{sample.table}{object of class \code{sample_table}, inherited from
\code{\link{read_sampleTable}}.}

\item{system}{character. The name of digital PCR system used to generate
the data. It must be either Thermo Fisher or Bio-Rad. Abbreviations are
also accepted.}

\item{file.location}{character. Full path name to reference and sample
files location. The default corresponds to the working directory,
(\code{\link[base]{getwd}}). Tilde expansion (see
(\code{\link[base]{path.expand}})) is performed.}

\item{reference.quality}{numeric. Between 0 and 1. Quality threshold to
subset the data. If different thresholds have to be applied to various
reference samples, a vectror of the same length of number of reference
samples has to be provided. Used only when the \code{system} is Thermo
Fisher.}

\item{eps, minPts}{numeric. Input parameters for the DBSCAN algorithm. If
they match the paramters of \code{\link{reference_dbscan}} template file,
the data are retrived from the template.}
}
\value{
An object of class \code{read_reference} containing a sublist for
  each reference. Each sublist has the following components:
  \item{quality}{value of the \code{reference.quality} parameter.}
  \item{data}{a matrix with the fluorescence intensities and quality
  values.}
  \item{dbscan}{an object of class \code{dbscan_fast}, inherited from
    \code{\link[dbscan]{dbscan}}. This component is available only if a
    \code{\link{reference_dbscan}} template file is used to retrive the
    data.}
}
\description{
This function reads the results files of reference samples listed in the
sample table. Fluoresce intensity and quality value (just for Thermo Fisher)
are collected.
If a \code{\link{reference_dbscan}} template file with the same input
paramters (reference ID, eps, minPts) is available, fluorescence data,
quality value and dbscan analysis results are retrived from the template
file.
}
\examples{
library(dPCP)

#Find path of sample table and location of reference and input files
sampleTable <- system.file("extdata", "Template_sampleTable.csv",
                     package = "dPCP")

fileLoc <- system.file("extdata", package = "dPCP")

#Read sample table file
sample.table <- read_sampleTable(sampleTable, system = "bio-rad",
                                 file.location = fileLoc)

#Read reference files
ref <- read_reference(sample.table, system = "bio-rad",
                      file.location = fileLoc)
}
