% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_sample.R
\name{ts_sample}
\alias{ts_sample}
\title{Time Series Sample}
\usage{
ts_sample(ts, test_size = 1, offset = 0)
}
\arguments{
\item{ts}{time series.}

\item{test_size}{integer: size of test data (default = 1).}

\item{offset}{integer: starting point (default = 0).}
}
\value{
returns a list with the two samples
}
\description{
Separates the \code{ts_data} into training and test.
It separates the test size from the last observations minus an offset.
The offset is important to allow replication under different recent origins.
The data for train uses the number of rows of a \code{ts_data} minus the test size and offset.
}
\examples{
#setting up a ts_data
data(sin_data)
ts <- ts_data(sin_data$y, 10)

#separating into train and test
test_size <- 3
samp <- ts_sample(ts, test_size)

#first five rows from training data
ts_head(samp$train, 5)

#last five rows from training data
ts_head(samp$train[-c(1:(nrow(samp$train)-5)),])

#testing data
ts_head(samp$test)
}
