% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_duration_outliers.R
\name{detect_duration_outliers}
\alias{detect_duration_outliers}
\title{Detect activity duration outliers}
\usage{
detect_duration_outliers(activitylog, ..., details, filter_condition)
}
\arguments{
\item{activitylog}{The activity log}

\item{...}{for each activity to be checked, an argument "activity_name" = duration_within(...) to define bounds. See ?duration_within}

\item{details}{Boolean indicating wheter details of the results need to be shown}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}
}
\value{
activitylog containing the rows of the original activity log for which activity duration outliers are detected
Information on the presence of activity duration outliers
}
\description{
Function detecting duration outliers for a particular activity
}
\examples{
\donttest{
data("hospital_actlog")
detect_duration_outliers(activitylog = hospital_actlog,
     Treatment = duration_within(bound_sd = 1))
}
}
\seealso{
\code{\link{duration_within}}
}
