% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rbm.Learn.R
\name{trainRBM}
\alias{trainRBM}
\title{Trains a \code{\link{RBM}} with contrastive divergence}
\usage{
trainRBM(rbm, trainData, numEpochs = 1, numCD = 1, ...)
}
\arguments{
\item{rbm}{A instance of the class \code{\link{RBM}}.}

\item{trainData}{The data matrix for the training}

\item{numEpochs}{The number of training iterations}

\item{numCD}{Number of contrastive divergence iterations}

\item{...}{Additional parameters for the unit functions}
}
\description{
The function trains a restricted Boltzmann machine (\code{\link{RBM}}) with
the contrastive divergence method.
}
\details{
This function is build on the basis of the code from G. Hinton et.
  al. (http://www.cs.toronto.edu/~hinton/MatlabForSciencePaper.html - last
  visit 06.06.2013) for the pre training of deep belief nets. The original
  code is located in the files 'rbm.m' and 'rbmhidlinear.m'. It iterates in
  every epoche over the batches and calculates the updates for the weights.
  If it is the first CD iteration or the CD iterations are finished, the
  hidden units are calculated with the real value activations of the visible
  units, otherwise with the binary activations. To tell the unit functions
  the actual state of the training, the function generates a array with the
  following running parameters and passes them to the units: Number of
  epochs: "numEpochs", current epochs: "currentEpoch", Number of batches:
  "numBatches", current batch: "currentBatch", Maximal CD iterations:
  "numCD", current CD iteration: "currentCD", CD is finished: "finishCD".
  (see source code from \code{\link{sigmUnitFuncSwitch}} for an example).
}
\seealso{
\code{\linkS4class{RBM}}
}

