% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark.R
\name{darchBench}
\alias{darchBench}
\title{Benchmarking wrapper for \code{darch}}
\usage{
darchBench(..., bench.times = 1, bench.save = F,
  bench.dir = "./darch.benchmark", bench.continue = T, bench.delete = F,
  bench.seeds = NULL, output.capture = bench.save, logLevel = NULL)
}
\arguments{
\item{...}{Parameters to the \code{\link{darch}} function}

\item{bench.times}{How many benchmark runs to perform}

\item{bench.save}{Whether to save benchmarking results to a directory}

\item{bench.dir}{Path (relative or absolute) including directory where
benchmark results are saved if \code{bench.save} is true}

\item{bench.continue}{Whether the benchmark is to be continued from an
earlier run. If \code{TRUE}, existing benchmark results are looked for in
the directory given in \code{bench.dir} and new results are appended.
If both this and \code{bench.continue} are \code{FALSE} and
the directory given in \code{bench.dir} does already exist, the training
will be aborted with an error.}

\item{bench.delete}{Whether to delete the contents of \code{bench.dir} if
\code{bench.continue} is \code{FALSE}. Caution: This will attempt to delete
ALL files in the given directory, use at your own risk!}

\item{bench.seeds}{Vector of seeds, one for each run. Will be passed to
\code{\link{darch}}.}

\item{output.capture}{Whether to capture R output in \code{.Rout} files in
the given directory. This is the only way of gaining access to the R
output since the foreach loop will not print anything to the console. Will
be ignored if \code{bench.save} is \code{FALSE}.}

\item{logLevel}{\code{\link{futile.logger}} log level. Uses the currently
set log level by default, which is \code{futile.logger::flog.info} if it
was not changed. Other available levels include, from least to most
verbose: \code{FATAL}, \code{ERROR}, \code{WARN}, \code{DEBUG}, and
\code{TRACE}.}
}
\value{
List of \code{DArch} instances; the results of each call to
  \code{darch}.
}
\description{
Simple benchmarking function which wraps around the \code{\link{darch}}
function for users who can't or don't want to use the caret package for
benchmarking. This function requires the \code{foreach}
package to work, and will perform parallel benchmarks if an appropriate
backend was registered beforehand.
}
\examples{
\dontrun{
data(iris)
modelList <- darchBench(Species ~ ., iris, c(0, 50, 0),
 preProc.params = list(method = c("center", "scale")),
 darch.unitFunction = c("sigmoidUnit", "softmaxUnit"),
 darch.numEpochs = 30, bench.times = 10, bench.save = T)
}
}
\seealso{
Other darch interface functions: \code{\link{darchTest}},
  \code{\link{darch}}, \code{\link{plot.DArch}},
  \code{\link{predict.DArch}}, \code{\link{print.DArch}}
}

