% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darchUnitFunctions.R
\name{softplusUnit}
\alias{softplusUnit}
\title{Softplus unit function with unit derivatives.}
\usage{
softplusUnit(input, ...)
}
\arguments{
\item{input}{Input for the activation function.}

\item{...}{Additional parameters, not used.}
}
\value{
A list with the softplus activation in the first entry and
 the derivative of the activation in the second entry.
}
\description{
The function calculates the activation of the units and returns a list, in
which the first entry is the softmax activation of the units and the second
entry is the derivative of the transfer function. Softplus is a smoothed
version of the rectified linear activation function.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris, darch.unitFunction = "softplusUnit")
}
}
\references{
Dugas, Charles, Yoshua Bengio, Francois Belisle, Claude Nadeau,
 and Rene Garcia (2001). "Incorporating Second-Order Functional Knowledge for
 Better Option Pricing". In: Advances in Neural Information Processing
 Systems, pp. 472-478.
}
\seealso{
Other darch unit functions: \code{\link{exponentialLinearUnit}},
  \code{\link{linearUnit}}, \code{\link{maxoutUnit}},
  \code{\link{rectifiedLinearUnit}},
  \code{\link{sigmoidUnit}}, \code{\link{softmaxUnit}},
  \code{\link{tanhUnit}}
}

