% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.reproducibility.r
\name{gl.report.reproducibility}
\alias{gl.report.reproducibility}
\title{Report summary of RepAvg (repeatability averaged over both alleles for each locus) or reproducibility (repeatability of the scores
for fragment presence/absence).}
\usage{
gl.report.reproducibility(x, boxplot = "adjusted", range = 1.5, verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP data [required]}

\item{boxplot}{-- if 'standard', plots a standard box and whisker plot; if 'adjusted',
plots a boxplot adjusted for skewed distributions [default 'adjusted']}

\item{range}{-- specifies the range for delimiting outliers [default = 1.5 interquartile ranges]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
-- Tabulation of repeatability against prospective Thresholds
}
\description{
SNP datasets generated by DArT have an index, RepAvg, generated by reproducing the data independently for 30% of loci.
RepAvg is the proportion of alleles that give a repeatable result, averaged over both alleles for each locus.
}
\details{
In the case of fragment presence/absence data (SilicoDArT), repeatability is the percentage of scores that are repeated
in the technical replicate dataset.

A histogram and whisker plot are produced to aid in selecting a threshold.
}
\examples{
# SNP data
  out <- gl.report.reproducibility(testset.gl)
# Tag P/A data
  out <- gl.report.reproducibility(testset.gs)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
