% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2gds.r
\name{gl2gds}
\alias{gl2gds}
\title{Convert a genlight object to gds format}
\usage{
gl2gds(x, outfile = "gl2gds.gds", outpath = tempdir(), verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP data [required]}

\item{outfile}{-- file name of the output file (including extension) [default gl2gds.gds]}

\item{outpath}{-- path where to save the output file [default tempdir(), mandated by CRAN]. Use outpath=getwd() or outpath="." when calling this function to direct output files to your working directory.}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\description{
Package SNPRelate relies on a bit-level representation of a SNP dataset that competes with \{adegenet\} genlight
objects and associated files. This function saves a genlight object to a gds format file.
}
\examples{
\donttest{
gl2gds(testset.gl)
}
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
