% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.ld.r
\name{gl.report.ld}
\alias{gl.report.ld}
\title{Calculates pairwise population based Linkage Disequilibrium across all loci
 using the specified number of cores}
\usage{
gl.report.ld(
  x,
  name = NULL,
  save = TRUE,
  outpath = tempdir(),
  nchunks = 2,
  ncores = 1,
  chunkname = NULL,
  probar = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{A genlight or genind object created (genlight objects are internally
converted via \code{\link{gl2gi}} to genind) [required].}

\item{name}{Character string for rdata file. If not given genind object name
is used [default NULL].}

\item{save}{Switch if results are saved in a file [default TRUE].}

\item{outpath}{Folder where chunks and results are saved (if save=TRUE)
[default tempdir()].}

\item{nchunks}{How many subchunks will be used (the less the faster, but if
the routine crashes more bits are lost) [default 2].}

\item{ncores}{How many cores should be used [default 1].}

\item{chunkname}{The name of the chunks for saving [default NULL].}

\item{probar}{if TRUE, a progress bar is displayed for long loops
[default = TRUE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
Returns calculation of pairwise LD across all loci between
subpopulations. This functions uses if specified many cores on your computer
to speed up. And if save is used can restart (if save=TRUE is used) with the
same command starting where it crashed. The final output is a data frame that
 holds all statistics of pairwise LD between loci. (See ?LD in package
 genetics for details).
}
\description{
This function is implemented in a parallel fashion to speed up the process.
There is also the ability to restart the function if crashed by specifying
the chunk file names or restarting the function exactly in the same way as in
the first run. This is implemented because sometimes, due to connectivity loss
between cores, the function may crash half way. Before running the function, 
it is advisable to use the function \code{\link{gl.filter.allna}} to remove
 loci with all missing data.
}
\author{
Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
