% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/node_conversion_dendrogram.R
\name{as.dendrogram.Node}
\alias{as.dendrogram.Node}
\title{Convert a \code{Node} to a \code{dendrogram}}
\usage{
\method{as.dendrogram}{Node}(object, heightAttribute = DefaultPlotHeight,
  edgetext = FALSE, ...)
}
\arguments{
\item{object}{The Node to convert}

\item{heightAttribute}{The attribute (field name or function) storing the height}

\item{edgetext}{If TRUE, then the for non-leaf nodes the node name is stored as the dendrogram's edge text.}

\item{...}{Additional parameters}
}
\value{
An object of class dendrogram
}
\description{
Convert a \code{data.tree} structure to a \code{\link{dendrogram}}
}
\examples{
data(acme)
acmed <- as.dendrogram(acme)
plot(acmed, center = TRUE)

#you can take an attribute for the height:
acme$Do( function(x) x$myPlotHeight <- (10 - x$level))
acmed <- as.dendrogram(acme, heightAttribute = "myPlotHeight")
plot(acmed, center = TRUE)

#or directly a function
acmed <- as.dendrogram(acme, heightAttribute = function(x) 10 - x$level)
plot(acmed)
}
\seealso{
Other Conversions from Node: \code{\link{ToNewick}}
}

