% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_conversion_dataframe.R
\name{as.data.frame.Node}
\alias{ToDataFrameNetwork}
\alias{ToDataFrameTable}
\alias{ToDataFrameTree}
\alias{ToDataFrameTypeCol}
\alias{as.data.frame.Node}
\title{Convert a \code{data.tree} structure to a \code{data.frame}}
\usage{
\method{as.data.frame}{Node}(x, row.names = NULL, optional = FALSE, ...,
  traversal = c("pre-order", "post-order", "in-order", "level", "ancestor"),
  pruneFun = NULL, filterFun = NULL, inheritFromAncestors = FALSE)

ToDataFrameTree(x, ..., pruneFun = NULL)

ToDataFrameTable(x, ..., pruneFun = NULL)

ToDataFrameNetwork(x, ..., direction = c("climb", "descend"),
  pruneFun = NULL, inheritFromAncestors = FALSE)

ToDataFrameTypeCol(x, ..., type = "level", prefix = type, pruneFun = NULL)
}
\arguments{
\item{x}{The root \code{Node} of the tree or sub-tree to be convert to a data.frame}

\item{row.names}{\code{NULL} or a character vector giving the row names for the data frame. 
Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and converting column names 
(to syntactic names: see make.names) is optional.}

\item{...}{the attributes to be added as columns of the data.frame. See \code{\link{Get}} for details.
If a specific Node does not contain the attribute, \code{NA} is added to the data.frame.}

\item{traversal}{any of 'pre-order' (the default), 'post-order', 'in-order', 'level', or 'ancestor'. See \code{\link{Traverse}} for details.}

\item{pruneFun}{allows providing a a prune criteria, i.e. a function taking a \code{Node} as an input, and returning \code{TRUE} or \code{FALSE}. 
If the pruneFun returns FALSE for a Node, then the Node and its entire sub-tree will not be considered.}

\item{filterFun}{a function taking a \code{Node} as an argument. See \code{\link{Traverse}} for details.}

\item{inheritFromAncestors}{if FALSE, and if the attribute is a field or a method, then only a \code{Node} itself is
searched for the field/method. If TRUE, and if the \code{Node} does not contain the attribute, then ancestors are also searched.}

\item{direction}{when converting to a network, should the edges point from root to children ("climb") or from child to parent ("descend")?}

\item{type}{when converting type columns, the \code{type} is the discriminator, i.e. an attribute (e.g. field name) of each node}

\item{prefix}{when converting type columns, the prefix used for the column names. Can be NULL to omit prefixes.}
}
\value{
ToDataFrameTree: a \code{data.frame}, where each row represents a \code{Node} in the tree or sub-tree 
spanned by \code{x}, possibly pruned according to \code{pruneFun}.

ToDataFrameTable: a \code{data.frame}, where each row represents a leaf \code{Node} in the tree or sub-tree
spanned by \code{x}, possibly pruned according to \code{pruneFun}.

ToDataFrameNetwork: a \code{data.frame}, where each row represents a \code{Node} in the tree or sub-tree 
spanned by \code{x}, possibly pruned according to \code{pruneFun}. The first column is called 'from', while the
second is called 'to', describing the parent to child edge (for direction "climb") or the child to parent edge (for direction "descend").
If \code{\link{AreNamesUnique}} is TRUE, then the Network is
based on the \code{Node$name}, otherwise on the \code{Node$pathString}

ToDataFrameTypeCol: a \code{data.frame} in table format (i.e. where each row represents a leaf in the tree or sub-tree 
spanned by \code{x}), possibly pruned according to \code{pruneFun}. In addition to \code{...}, each distinc
\code{type} is output to a column.
}
\description{
Convert a \code{data.tree} structure to a \code{data.frame}
}
\examples{
data(acme)
acme$fieldsAll
as.data.frame(acme, row.names = NULL, optional = FALSE, "cost", "p") 

ToDataFrameTree(acme, "cost", "p")
ToDataFrameNetwork(acme, "cost", "p", direction = "climb")
ToDataFrameTable(acme, "cost", "p")
ToDataFrameTypeCol(acme)

#use the pruneFun:
acme$Do(function(x) x$totalCost <- Aggregate(x, "cost", sum), traversal = "post-order")
ToDataFrameTree(acme, "totalCost", pruneFun = function(x) x$totalCost > 300000)

#inherit
acme$Set(floor = c(1, 2, 3), filterFun = function(x) x$level == 2)
as.data.frame(acme, row.names = NULL, optional = FALSE, "floor", inheritFromAncestors = FALSE)  
as.data.frame(acme, row.names = NULL, optional = FALSE, "floor", inheritFromAncestors = TRUE)  

#using a function as an attribute:
acme$Accounting$Head <- "Mrs. Numright"
acme$Research$Head <- "Mr. Stein"
acme$IT$Head <- "Mr. Squarehead"
ToDataFrameTable(acme, department = function(x) x$parent$name, "name", "Head", "cost")
  
#complex TypeCol
acme$IT$Outsource$AddChild("India")
acme$IT$Outsource$AddChild("Poland")
acme$Set(type = c('company', 'department', 'project', 'project', 'department', 
                  'project', 'project', 'department', 'program', 'project', 
                  'project', 'project', 'project'
                  )
        )
print(acme, 'type')
ToDataFrameTypeCol(acme, type = 'type')
      
}

