% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{CheckNameReservedWord}
\alias{CheckNameReservedWord}
\title{Checks whether \code{name} is a reserved word, as defined in \code{NODE_RESERVED_NAMES_CONST}.}
\usage{
CheckNameReservedWord(name, check = c("check", "no-warn", "no-check"))
}
\arguments{
\item{name}{the name to check}

\item{check}{Either
\itemize{
 \item{\code{"check"}: if the name conformance should be checked and warnings should be printed in case of non-conformance (the default)}
 \item{\code{"no-warn"}: if the name conformance should be checked, but no warnings should be printed in case of non-conformance (if you expect non-conformance)}
 \item{\code{"no-check" or FALSE}: if the name conformance should not be checked; use this if performance is critical. However, in case of non-conformance, expect cryptic follow-up errors}
}}
}
\description{
Checks whether \code{name} is a reserved word, as defined in \code{NODE_RESERVED_NAMES_CONST}.
}
