% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_methods_traversal.R
\name{Get}
\alias{Get}
\title{Traverse a Tree and Collect Values}
\usage{
# OO-style:
#node$Get(attribute, 
#        ..., 
#        traversal = c("pre-order", "post-order", "in-order", "level", "ancestor"), 
#        pruneFun = NULL, 
#        filterFun = NULL, 
#        format = FALSE, 
#        inheritFromAncestors = FALSE)
         
# traditional:
Get(nodes, 
    attribute, 
    ..., 
    format = FALSE, 
    inheritFromAncestors = FALSE, 
    simplify = c(TRUE, FALSE, "array", "regular"))
}
\arguments{
\item{nodes}{The nodes on which to perform the Get (typically obtained via \code{\link{Traverse}})}

\item{attribute}{determines what is collected. The \code{attribute} can be
\itemize{
  \item a.) the name of a \bold{field} or a \bold{property/active} of each \code{Node} in the tree, e.g. \code{acme$Get("p")} or \code{acme$Get("position")}
  \item b.) the name of a \bold{method} of each \code{Node} in the tree, e.g. \code{acme$Get("levelZeroBased")}, where e.g. \code{acme$levelZeroBased <- function() acme$level - 1}
  \item c.) a \bold{function}, whose first argument must be a \code{Node} e.g. \code{acme$Get(function(node) node$cost * node$p)}
 }}

\item{...}{in case the \code{attribute} is a function or a method, the ellipsis is passed to it as additional arguments.}

\item{format}{if \code{FALSE} (the default), no formatting is being used. If \code{TRUE}, then the first formatter (if any) found along the ancestor path is being used for formatting 
(see \code{\link{SetFormat}}). If \code{format} is a function, then the collected value is passed to that function, and the result is returned.}

\item{inheritFromAncestors}{if \code{TRUE}, then the path above a \code{Node} is searched to get the \code{attribute} in case it is NULL.}

\item{simplify}{same as \code{\link{sapply}}, i.e. TRUE, FALSE or "array". Additionally, you can specify "regular" if
each returned value is of length > 1, and equally named. See below for an example.}
}
\value{
a vector containing the \code{atrributes} collected during traversal, in traversal order. \code{NULL} is converted
to NA, such that \code{length(Node$Get) == Node$totalCount}
}
\description{
The \code{Get} method is one of the most important ones of the \code{data.tree} package. It lets you traverse a tree
and collect values along the way. Alternatively, you can call a method or a function on each \code{\link{Node}}.
}
\examples{
data(acme)
acme$Get("level")
acme$Get("totalCount")
 

acme$Get(function(node) node$cost * node$p,
         filterFun = isLeaf)

#This is equivalent:
nodes <- Traverse(acme, filterFun = isLeaf)
Get(nodes, function(node) node$cost * node$p)

   
#simplify = "regular" will preserve names
acme$Get(function(x) c(position = x$position, level = x$level), simplify = "regular")
 
}
\seealso{
\code{\link{Node}}

\code{\link{Set}}

\code{\link{Do}}

\code{\link{Traverse}}
}
