% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_methods_sideeffect.R
\name{Prune}
\alias{Prune}
\title{Prunes a tree.}
\usage{
Prune(node, pruneFun)
}
\arguments{
\item{node}{The root of the sub-tree to be pruned}

\item{pruneFun}{allows providing a prune criteria, i.e. a function taking a \code{Node} as an input, and returning \code{TRUE} or \code{FALSE}. 
If the pruneFun returns FALSE for a Node, then the Node and its entire sub-tree will not be considered.}
}
\value{
the number of nodes removed
}
\description{
Pruning refers to removing entire subtrees. This function has side-effects, it modifies your data.tree structure!
}
\examples{
data(acme)
acme$Do(function(x) x$cost <- Aggregate(x, "cost", sum))
Prune(acme, function(x) x$cost > 700000)
print(acme, "cost")

}
\seealso{
\code{\link{Node}}
}
