% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateFromDate.R
\name{generateDateDiffs}
\alias{generateDateDiffs}
\title{Date difference}
\usage{
generateDateDiffs(
  dataSet,
  cols = "auto",
  analysisDate = NULL,
  units = "years",
  drop = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{cols}{List of date column(s) name(s) of dataSet to comute difference on. To transform all 
dates, set it to "auto". (character, default to "auto")}

\item{analysisDate}{Static date (Date or POSIXct, optional)}

\item{units}{Unit of difference between too dates (string, default to 'years')}

\item{drop}{Should \code{cols} be dropped after generation (logical, default to FALSE)}

\item{verbose}{should the function log (logical, default to TRUE)}

\item{...}{Other arguments such as \code{name_separator} to separate words in new columns names
(character, default to ".")}
}
\value{
dataSet (as a \code{\link{data.table}}) with more columns. 
A numeric column has been added for every couple of Dates. The result is in years.
}
\description{
Perform the differences between all dates of the dataSet set and optionally with a static date.
}
\details{
\code{units} is the same as \code{\link{difftime}} units, but with one more possiblity: years.
}
\examples{
# First build a useful dataSet set
require(data.table)
dataSet <- data.table(ID = 1:100, 
                  date1 = seq(from = as.Date("2010-01-01"), 
                              to = as.Date("2015-01-01"), 
                              length.out = 100), 
                  date2 = seq(from = as.Date("1910-01-01"), 
                              to = as.Date("2000-01-01"), 
                              length.out = 100)
                  )

# Now let's compute
dataSet <- generateDateDiffs(dataSet, cols = "auto", analysisDate = as.Date("2016-11-14"))
}
