% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddo_ddf_methods.R
\name{addData}
\alias{addData}
\title{Add Key-Value Pairs to a Data Connection}
\usage{
addData(conn, data, overwrite = FALSE)
}
\arguments{
\item{conn}{a kvConnection object}

\item{data}{a list of key-value pairs (list of lists where each sub-list has two elements, the key and the value)}

\item{overwrite}{if data with the same key is already present in the data, should it be overwritten? (does not work for HDFS connections)}
}
\description{
Add key-value pairs to a data connection
}
\note{
This is generally not recommended for HDFS as it writes a new file each time it is called, and can result in more individual files than Hadoop likes to deal with.
}
\examples{
\dontrun{
  # connect to empty HDFS directory
  conn <- hdfsConn("/test/irisSplit")
  # add some data
  addData(conn, list(list("1", iris[1:10,])))
  addData(conn, list(list("2", iris[11:110,])))
  addData(conn, list(list("3", iris[111:150,])))
  # represent it as a distributed data frame
  hdd <- ddf(conn)
}
}
\author{
Ryan Hafen
}
\seealso{
\code{\link{removeData}}, \code{\link{localDiskConn}}, \code{\link{hdfsConn}}
}

