% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddo_ddf_methods.R
\name{ddo-ddf-attributes}
\alias{ddo-ddf-attributes}
\alias{getAttribute}
\alias{getAttributes}
\alias{getAttributes.ddf}
\alias{getAttributes.ddo}
\alias{hasAttributes}
\alias{hasAttributes.ddf}
\alias{setAttributes}
\alias{setAttributes.ddf}
\alias{setAttributes.ddo}
\title{Managing attributes of 'ddo' or 'ddf' objects}
\usage{
setAttributes(obj, attrs)

\method{setAttributes}{ddf}(obj, attrs)

\method{setAttributes}{ddo}(obj, attrs)

getAttribute(obj, attrName)

getAttributes(obj, attrNames)

\method{getAttributes}{ddf}(obj, attrNames)

\method{getAttributes}{ddo}(obj, attrNames)

hasAttributes(obj, ...)

\method{hasAttributes}{ddf}(obj, attrNames)
}
\arguments{
\item{obj}{'ddo' or 'ddf' object}

\item{attrs}{a named list of attributes to set}

\item{attrName}{name of the attribute to get}

\item{attrNames}{vector of names of the attributes to get}

\item{\ldots}{additional arguments}
}
\description{
These are called internally in various datadr functions.  They are not meant for use outside of there, but are exported for convenience, and can be useful for better understanding ddo/ddf objects.
}
\examples{
d <- divide(iris, by = "Species")
getAttribute(d, "keys")
}

