% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataops_lapply.R
\name{drLapply}
\alias{drLapply}
\title{Apply a function to all key-value pairs of a ddo/ddf object}
\usage{
drLapply(X, FUN, combine = combDdo(), output = NULL, overwrite = FALSE,
  params = NULL, packages = NULL, control = NULL, verbose = TRUE)
}
\arguments{
\item{X}{an object of class "ddo" of "ddf"}

\item{FUN}{a function to be applied to each subset}

\item{combine}{optional method to combine the results}

\item{output}{a "kvConnection" object indicating where the output data should reside (see \code{\link{localDiskConn}}, \code{\link{hdfsConn}}).  If \code{NULL} (default), output will be an in-memory "ddo" object.}

\item{overwrite}{logical; should existing output location be overwritten? (also can specify \code{overwrite = "backup"} to move the existing output to _bak)}

\item{params}{a named list of objects external to the input data that are needed in the distributed computing (most should be taken care of automatically such that this is rarely necessary to specify)}

\item{packages}{a vector of R package names that contain functions used in \code{fn} (most should be taken care of automatically such that this is rarely necessary to specify)}

\item{control}{parameters specifying how the backend should handle things (most-likely parameters to \code{rhwatch} in RHIPE) - see \code{\link{rhipeControl}} and \code{\link{localDiskControl}}}

\item{verbose}{logical - print messages about what is being done}
}
\value{
depends on \code{combine}
}
\description{
Apply a function to all key-value pairs of a ddo/ddf object and get a new ddo object back, unless a different \code{combine} strategy is specified.
}
\examples{
bySpecies <- divide(iris, by = "Species")
drLapply(bySpecies, function(x) x$Sepal.Width)
}
\author{
Ryan Hafen
}
\seealso{
\code{\link{recombine}}, \code{\link{drFilter}}, \code{\link{drJoin}}, \code{\link{combDdo}}, \code{\link{combRbind}}
}

