% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/compare_fsm.R
\name{compare_fsm}
\alias{compare_fsm}
\title{Compares FSMs}
\usage{
compare_fsm(users, gas, comparison = "manhattan")
}
\arguments{
\item{users}{Numeric vector or numeric matrix with a predefined FSM}

\item{gas}{Numeric vector or numeric matrix with an evolved FSM}

\item{comparison}{Character string of length one with either "manhattan",
  "euclidean", or "binary".}
}
\value{
Numeric vector of length one for the distance between the two
  supplied FSMs, calculated according to the comparison argument.
}
\description{
\code{compare_fsm} uses a specified distance measure to compare FSMs.
}
\details{
Compares a user-defined FSM to a decoded estimated FSM. If you have have FSMs
that may have values in the matrices that arent all simple integers, you can
use the distance metric that is most appropriate. Euclidean does
sqrt(sum((x_i - y_i)^2)) - the L2 norm. Manhattan takes abs diff between
them - the L1 norm. Binary treats non-zero elements as "on" and zero
elements as "off" and distance is the proportion of bits in which only one is
on amongst those in which at least one is on.
}

