context("dvariable")

test_that("creates correct class of dvariable", {
  vlogical <- dvariable(c(FALSE,TRUE,FALSE))
  vinteger <- dvariable(1:10)
  vnumeric <- dvariable(1:10 + 0.1)
  vfactor <- dvariable(factor(1:10))
  vdate <- dvariable(as.Date("2000-01-01") + 1:10)
  vposixt <- dvariable(as.POSIXct("2000-01-01", tz= "GMT") + 1:10)
  
  mlogical <- dvariable(matrix(TRUE))
  minteger <- dvariable(matrix(as.integer(1)))
  mdouble <- dvariable(matrix(1))

  alogical <- dvariable(array(TRUE))
  ainteger <- dvariable(array(as.integer(1)))
  adouble <- dvariable(array(1))
  
  expect_that(vlogical, is_a('vlogical'))
  expect_that(vinteger, is_a('vinteger'))
  expect_that(vnumeric, is_a('vnumeric'))
  expect_that(vfactor, is_a('vfactor'))
  expect_that(vdate, is_a('vdate'))
  expect_that(vposixt, is_a('vposixt'))
  expect_that(mlogical, is_a('mlogical'))
  expect_that(minteger, is_a('minteger'))
  expect_that(mdouble, is_a('mdouble'))
  expect_that(alogical, is_a('alogical'))
  expect_that(ainteger, is_a('ainteger'))
  expect_that(adouble, is_a('adouble'))
})
