% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxies.R
\name{update_bubbles}
\alias{update_bubbles}
\title{Dynamically add bubbles}
\usage{
update_bubbles(proxy, longitude, latitude, radius, color, name, ...)
}
\arguments{
\item{proxy}{a proxy as returned by \code{\link{datamapsProxy}}.}

\item{longitude, latitude}{coordinates of bubbles.}

\item{radius}{radius of bubbles.}

\item{color}{color of bubbles.}

\item{name}{name of bubbles.}

\item{...}{any other variable to use in tooltip.}
}
\description{
Dynamically add bubble using Shiny.
}
\examples{
\dontrun{
library(shiny)

ui <- fluidPage(
 numericInput(
   "lon",
   "Longitude",
   value = 50
 ),
 numericInput(
   "lat",
   "Latitude",
   value = 50
 ),
 textInput(
   "city",
   "City",
   value = "City"
 ),
 sliderInput(
   "value",
   "Value",
   min = 1,
   max = 4,
   step = 1,
   value = 3
 ),
 actionButton(
   "sub",
   "Submit"
 ),
 datamapsOutput("map")
)

server <- function(input, output){

  coords <- data.frame(city = c("London", "New York", "Beijing", "Sydney"),
                       lon = c(-0.1167218, -73.98002, 116.3883, 151.18518),
                       lat = c(51.49999, 40.74998, 39.92889, -33.92001),
                       values = 1:4)

  update <- reactive({
    df <- data.frame(city = input$city, lon = input$lon, lat = input$lat, values = input$value)
    rbind.data.frame(coords, df)
  })

  output$map <- renderDatamaps({
    coords \%>\%
      datamaps() \%>\%
      add_bubbles(lon, lat, values * 2, values, city)
  })

  observeEvent(input$sub, {
    datamapsProxy("map") \%>\%
      add_data(update()) \%>\% # pass updated data
      update_bubbles(lon, lat, values * 2, values, city) # update
  })

}

shinyApp(ui, server)
}

}
