% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrt.r
\name{lrt}
\alias{lrt}
\title{Computes a likelihood ratio test between a reduced model and a full 
model}
\usage{
lrt(modr, modf)
}
\arguments{
\item{modr}{is a previously fitted model having less parameters than modf}

\item{modf}{is a previously fitted model having more parameters than modr}
}
\value{
This function returns an object having the following elements:
"loglik.Modr" maximized log-likelihood of modr; "loglik.Modf" maximized
 log-likelihood of modf;
 "dif.loglik"  difference in log-likelihood between both models, and 
 "dif.df" difference in degrees of freedong of both models, and 
 "p-value" is the p-value for the LRT.
}
\description{
Computes a likelihood ratio test between a reduced model (modr) and a 
full model (modf). Both models must be
 previously fitted by maximum likelihood.
}
\details{
Double-check the order of the reduced and full model, before of 
using the model
}
\examples{

#not yet implemented
}
\references{
Pinheiro JC, and Bates DM. 2000. Mixed-effects models in S
   and Splus. Springer-Verlag, New York, NY. 528 p.
}
\author{
Christian Salas-Eljatib.
}
